<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

date_default_timezone_set('Asia/Kolkata');

if ($_SERVER['REQUEST_METHOD'] == 'POST' && isset($_POST['complaint_type']) && !empty(trim($_POST['message']))) {
    $complaint_type = mysqli_real_escape_string($ahk_conn, $_POST['complaint_type']);
    $message = mysqli_real_escape_string($ahk_conn, $_POST['message']);
    $utrnumber = isset($_POST['utrnumber']) && trim($_POST['utrnumber']) !== '' ? mysqli_real_escape_string($ahk_conn, $_POST['utrnumber']) : null;

    $site_id = 1;
    $user_id = $udata['id'];
    $username = $udata['name'];
    $remark = '';
    $status = 'Open';
    $date_time = date('Y-m-d H:i:s');

    $insert = mysqli_query($ahk_conn, "INSERT INTO complaints (site_id, user_id, username, utrnumber, complaint_type, message, remark, status, date_time) VALUES ('$site_id', '$user_id', '$username', '$utrnumber', '$complaint_type', '$message', '$remark', '$status', '$date_time')");

    if ($insert) {
        echo "<script>
            Swal.fire({
                icon: 'success',
                title: 'Complaint Submitted Successfully',
                showConfirmButton: false,
                timer: 1500
            }).then(() => { window.location = 'complaint_request_list'; });
        </script>";
    } else {
        echo "<script>
            Swal.fire({
                icon: 'error',
                title: 'Submission Failed',
                text: 'Please try again later.',
                confirmButtonText: 'OK'
            });
        </script>";
    }
}
?>


<!-- Created By FlexSecure {flex4upoint} --><div class="page-wrapper bg-light py-5" style="min-height: 85vh;">
    <div class="container">
        <h2 class="mb-4 text-primary fw-bold">Raise a Complaint</h2>

        <div class="card shadow-sm rounded-4 border-0">
            <div class="card-body p-5">
                <form id="complaintForm" method="POST" novalidate>
                    <!-- Complaint Type -->
                    <div class="form-floating mb-4">
                        <select class="form-select" id="complaint_type" name="complaint_type" required>
                            <option value="" selected disabled>Choose complaint type</option>
                            <?php
                            $complaint_types = [
                                "ADD MONEY",
                                "AADHAAR FINGERPRINT",
                                "AADHAAR NUMBER VERIFY",
                                "UID TO FULL DETAILS",
                                "AYUSHMAN CARD",
                                "e-SHRAM CARD",
                                "ENROLLMENT STATUS CHECK",
                                "CHALLAN DETAIL",
                                "DL PDF SERVER 1",
                                "DL PDF SERVER 2",
                                "LL EXAM",
                                "RATION PDF",
                                "RATION TO UID FIND",
                                "AADHAAR TO RATION PDF",
                                "AADHAAR TO PAN FIND",
                                "PAN DETAILS",
                                "PAN AADHAR LINK STATUS",
                                "PAN TO MASK AADHAR",
                                "IFSC CODE",
                                "MOBILE NUMBER VERIFY",
                                "PINCODE VERIFY",
                                "RC PDF SERVER 1",
                                "RC PDF SERVER 2",
                                "VOTER ADVANCE",
                                "VOTER MOBILE LINK",
                                "VOTER PDF",
                                "OTHER PROBLEM",
                                "I WANT REFUND MY AMOUNT"
                            ];
                            foreach ($complaint_types as $type) {
                                echo '<option value="'.htmlspecialchars($type).'">'.htmlspecialchars($type).'</option>';
                            }
                            ?>
                        </select>
                        <label for="complaint_type">Complaint Type <span class="text-danger">*</span></label>
                        <div class="invalid-feedback">Please select a complaint type.</div>
                    </div>

                    <!-- UTR Number (hidden by default) -->
                    <div class="form-floating mb-4 d-none" id="utr_container">
                        <input type="text" class="form-control" id="utrnumber" name="utrnumber" placeholder="UTR/Reference Number">
                        <label for="utrnumber">UTR / Reference Number (Optional)</label>
                    </div>

                    <!-- Message -->
                    <div class="form-floating mb-4">
                        <textarea class="form-control" placeholder="Describe your issue here..." id="message" name="message" style="height: 120px" required></textarea>
                        <label for="message">Complaint Message <span class="text-danger">*</span></label>
                        <div class="invalid-feedback">Please enter your complaint message.</div>
                    </div>

                    <button type="submit" class="btn btn-primary px-5 fw-semibold" id="submitBtn">Submit Complaint</button>
                </form>
            </div>
        </div>
    </div>
</div>


<!-- Bootstrap 5 JS Bundle (includes Popper) -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>

<!-- SweetAlert2 CDN (if not already included) -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const complaintType = document.getElementById('complaint_type');
    const utrContainer = document.getElementById('utr_container');
    const utrInput = document.getElementById('utrnumber');
    const form = document.getElementById('complaintForm');

    function toggleUTR() {
        if (complaintType.value === 'ADD MONEY') {
            utrContainer.classList.remove('d-none');
            utrInput.setAttribute('required', 'required');
        } else {
            utrContainer.classList.add('d-none');
            utrInput.removeAttribute('required');
            utrInput.value = '';
        }
    }

    complaintType.addEventListener('change', toggleUTR);

    // Initialize visibility on page load
    toggleUTR();

    // Bootstrap form validation
    form.addEventListener('submit', function(event) {
        if (!form.checkValidity()) {
            event.preventDefault();
            event.stopPropagation();
        }

        form.classList.add('was-validated');
    }, false);
});
</script>

<style>
    body {
        background: #f0f4f8;
    }

    .page-wrapper {
        font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
    }

    h2 {
        letter-spacing: 0.04em;
    }

    .form-floating > label {
        font-weight: 500;
    }

    .btn-primary {
        background: linear-gradient(135deg, #4a90e2, #357ABD);
        border: none;
        transition: background 0.3s ease;
        box-shadow: 0 4px 12px rgb(53 122 189 / 0.4);
    }

    .btn-primary:hover {
        background: linear-gradient(135deg, #357ABD, #2a5c95);
        box-shadow: 0 6px 15px rgb(42 92 149 / 0.6);
    }
</style>

										 		 		 <!--<button class="btn btn-danger font-weight-bold" type="button">Service Down</button>-->
								<!--start list page -->
 
<!--end page wrapper -->
<?php 
include('footer.php');
?>
<!-- Bootstrap JS -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<!--plugins-->
<script src="../template/ahkweb/assets/js/jquery.min.js"></script>
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/ahkweb/assets/plugins/chartjs/chart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-2.0.2.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-world-mill-en.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery.easy-pie-chart/jquery.easypiechart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/sparkline-charts/jquery.sparkline.min.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery-knob/excanvas.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery-knob/jquery.knob.js"></script>
<script>
$(function() {
    $(".knob").knob();
});
</script>
<script src="../template/ahkweb/assets/js/index.js"></script>
<!--app JS-->
<script src="../template/ahkweb/assets/js/app.js"></script>
<!-- datatable -->
<script src="../template/ahkweb/assets/plugins/datatable/js/jquery.dataTables.min.js"></script>
	<script src="../template/ahkweb/assets/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
<script>
		$(document).ready(function() {
			$('#example').DataTable();
		  } );
	</script>
	
	<script>
		$(document).ready(function() {
			var table = $('#example2').DataTable( {
				lengthChange: false,
				buttons: [ 'copy', 'excel', 'pdf', 'print']
			} );
		 
			table.buttons().container()
				.appendTo( '#example2_wrapper .col-md-6:eq(0)' );
		} );
	</script>
	
</body>



</html>