<?php 
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

// UTF-8 safe output
header('Content-Type: text/html; charset=UTF-8');

// ================== NOTIFICATION ==================
$query = "SELECT * FROM notification WHERE id='1'";
$res = mysqli_query($ahk_conn, $query);
$row = mysqli_fetch_assoc($res);
$message = $row ? $row['message'] : "No message found";
?>

<!-- SweetAlert (Welcome popup) -->
<script>
window.onload = function() {
    if (!localStorage.getItem("alertShown")) {
        Swal.fire({
            title: '🎉 Welcome to <?php echo ahkweb("webname"); ?>',
            text: 'Join our Telegram group for instant updates!',
            icon: 'success',
            confirmButtonText: 'Join Now'
        });
        localStorage.setItem("alertShown", "true");
    }
};
</script>

<!-- Fonts -->
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700&family=Nunito:wght@500;700&display=swap" rel="stylesheet">

<style>
body {
  background: #f4f6f8;
  font-family: 'Inter', sans-serif;
  color: #222;
  margin: 0;
  padding: 0;
}
.page-wrapper { padding: 22px 28px; }

.go-back {
  display: inline-flex;
  align-items: center;
  gap: 8px;
  background: #a86ddf;
  color: #fff;
  padding: 10px 16px;
  border-radius: 8px;
  text-decoration: none;
  font-weight: 600;
  box-shadow: 0 6px 18px rgba(168,109,223,0.18);
  margin-bottom: 18px;
  font-size: 15px;
}
.go-back .arrow { font-size: 18px; }

.header-row {
  display:flex;
  align-items:center;
  gap:18px;
  margin-bottom: 12px;
}

.services-wrap {
  width:100%;
  box-sizing: border-box;
  padding: 12px 8px;
}

.services-grid {
  display: flex;
  flex-wrap: wrap;
  gap: 50px;
  justify-content: flex-start;
  align-items: flex-start;
  padding-top: 12px;
}

.service-item {
  width: 220px;
  display: flex;
  flex-direction: column;
  align-items: center;
  text-align: center;
  transition: box-shadow .3s ease;
}
.service-item:hover {
  box-shadow: 0 8px 24px rgba(0,0,0,0.08);
  border-radius: 12px;
}

.service-circle {
  width: 200px;
  height: 200px;
  border-radius: 25%;
  display: flex;
  align-items: center;
  justify-content: center;
  box-shadow: 0 12px 28px rgba(18,24,34,0.08);
  transition: transform .28s ease, box-shadow .28s ease;
  border: 6px solid rgba(255,255,255,0.55);
  overflow: hidden;
  position: relative;
}

.service-circle[data-bg="pink"]   { background: linear-gradient(180deg, #ffecec, #ffdfe0); }
.service-circle[data-bg="blue"]   { background: linear-gradient(180deg, #e7f7ff, #e6f2ff); }
.service-circle[data-bg="green"]  { background: linear-gradient(180deg, #eaffef, #e7ffe6); }
.service-circle[data-bg="lav"]    { background: linear-gradient(180deg, #f6ecff, #f3e7ff); }
.service-circle[data-bg="cream"]  { background: linear-gradient(180deg, #fff6ea, #fff4e6); }
.service-circle[data-bg="grey"]   { background: linear-gradient(180deg, #f0f4f7, #eef3f9); }

.service-circle img {
  width: 150px;
  height: 150px;
  object-fit: contain;
  display: block;
  pointer-events: none;
  user-select: none;
  transition: transform .3s ease;
}

.service-item:hover .service-circle {
  transform: translateY(-10px);
  box-shadow: 0 24px 48px rgba(0,0,0,0.14);
}
.service-item:hover .service-circle img {
  transform: scale(1.12);
}

.service-label {
  margin-top: 16px;
  font-size: 16px;
  font-weight: 600;
  color: #222;
  max-width: 180px;
  line-height: 1.3;
}

@media (max-width: 1200px) {
  .service-item { width: 180px; }
  .service-circle { width: 160px; height:160px; }
  .service-circle img { width:80px; height:80px; }
}

@media (max-width: 768px) {
  .services-grid { gap: 24px; justify-content: center; }
  .service-item { width: 46%; max-width: 220px; }
}

@media (max-width: 480px) {
  .service-item { width: 100%; max-width: none; }
  .service-circle { width: 160px; height:160px; }
  .service-circle img { width:80px; height:80px; }
}

.service-link:focus .service-circle {
  outline: 3px solid rgba(37,117,252,0.18);
  transform: translateY(-6px);
}
</style>

<!-- ================== PAGE CONTENT ================== -->
<div class="page-wrapper">
  <div class="header-row">
    <a class="go-back" href="javascript:void(0)" onclick="history.back();">
      <span class="arrow">&#8592;</span> <span>Go Back</span>
    </a>
    <div style="margin-left:8px; color:#555; font-weight:600;">Hi, <?php echo $udata['name']; ?></div>
  </div>

  <div class="services-wrap">
    <h2 style="font-family: 'Nunito', sans-serif; font-weight:800; color:#222; margin: 6px 0 4px;">Ration Services</h2>
    <p style="color: #e53935; margin-top: 0; margin-bottom: 18px;">
  All the essential Ration-related services in one place - fast, secure, and easy to access!
</p>

    <div class="services-grid">
      <?php
      $services = [
          ["name" => "Ration Pdf Instant",         "link" => "Ration_Pdf_flx",               "image" => "../admin/uploads/service_icom/rartopntoadhha02r.png", "bg" => "pink"],
          ["name" => "Aadhaar To Ration Details",         "link" => "Ration_details",              "image" => "../admin/uploads/service_icom/rartopntoadh02ha02r.png", "bg" => "lav"],
        //   ["name" => "All State Ration Uid Find",      "link" => "ration2_uid_finder_all_state",                "image" => "../admin/uploads/service_icom/rartopntoadhhar.png", "bg" => "pink"],
        //   ["name" => "UP Ration Uid Find",         "link" => "ration_up_to_uid",                     "image" => "../admin/uploads/service_icom/rartopntoadhhar.png", "bg" => "cream"],
      ];

      $prices = [];
      $res = mysqli_query($ahk_conn, "SELECT service_name, price FROM pricing");
      while ($r = mysqli_fetch_assoc($res)) { $prices[$r['service_name']] = $r['price']; }

      foreach ($services as $svc):
        $name  = htmlspecialchars($svc['name']);
        $link  = htmlspecialchars($svc['link']);
        $img   = htmlspecialchars($svc['image']);
        $bg    = htmlspecialchars($svc['bg'] ?? 'grey');
      ?>
      <div class="service-item">
        <a class="service-link" href="<?php echo (strpos($link, 'http') === 0) ? $link : $link; ?>" <?php echo (strpos($link, 'http') === 0) ? 'target="_blank" rel="noopener noreferrer"' : ''; ?> aria-label="<?php echo $name; ?>" style="text-decoration:none;">
          <div class="service-circle" data-bg="<?php echo $bg; ?>">
            <img src="<?php echo $img; ?>" alt="<?php echo $name; ?> icon" />
          </div>
          <div class="service-label"><?php echo $name; ?></div>
        </a>
      </div>
      <?php endforeach; ?>
    </div>
  </div>
</div>

<?php include('footers.php'); ?>


<!-- Scripts -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="../template/ahkweb/assets/js/jquery.min.js"></script>
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/ahkweb/assets/plugins/chartjs/chart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-2.0.2.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-world-mill-en.js"></script>
<script src="../template/ahkweb/assets/js/app.js"></script>
</body>
</html>
