<?php
session_start();
include('header.php'); // must define $ahk_conn and $udata

// 🔒 Login check
if (!isset($udata) || empty($udata)) {
    header("Location: login.php");
    exit;
}

// ✅ Admin check
$isAdmin = (isset($udata['type']) && strtolower($udata['type']) === 'admin');
?>

<!-- start page wrapper -->
<div class="page-wrapper">
    <div class="page-content">
        <div class="card radius-10">
            <div class="card-body">
                <div class="d-flex align-items-center">
                    <div>
                        <h5 class="mb-0">
                            <?= $isAdmin ? 'All Wallet Transactions (Admin)' : 'My Wallet History'; ?>
                        </h5>
                    </div>
                </div>

                <hr>

                <div class="table-responsive">
                    <table id="example2" class="table align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="text-center">SL</th>

                                <?php if ($isAdmin): ?>
                                    <th class="text-center">User Name</th>
                                    <th class="text-center">User Phone</th>
                                    <th class="text-center">User Type</th>
                                <?php endif; ?>

                                <th class="text-center">Amount</th>
                                <th class="text-center">Balance</th>
                                <th class="text-center">Purpose</th>
                                <th class="text-center">Txn Type</th>
                                <th class="text-center">Status</th>
                                <th class="text-center">Date</th>
                            </tr>
                        </thead>
                        <tbody>

<?php
// 🔍 Admin sees all with user details
if ($isAdmin) {
    $sql = "
        SELECT 
            w.*, 
            u.name AS user_name, 
            u.phone AS user_phone, 
            u.type AS user_type
        FROM wallethistory w
        LEFT JOIN users u ON u.phone = w.userid
        ORDER BY w.id DESC
    ";
    $stmt = mysqli_prepare($ahk_conn, $sql);
} 
// 👤 Normal user sees own only
else {
    $sql = "
        SELECT * 
        FROM wallethistory 
        WHERE userid = ? 
        ORDER BY id DESC
    ";
    $stmt = mysqli_prepare($ahk_conn, $sql);
    mysqli_stmt_bind_param($stmt, "s", $udata['phone']);
}

mysqli_stmt_execute($stmt);
$result = mysqli_stmt_get_result($stmt);

if ($result && mysqli_num_rows($result) > 0) {
    $x = 0;
    while ($data = mysqli_fetch_assoc($result)) {
        $x++;
?>
        <tr>
            <td class="text-center"><?= $x; ?></td>

            <?php if ($isAdmin): ?>
                <td class="text-center"><?= htmlspecialchars($data['user_name'] ?? 'N/A'); ?></td>
                <td class="text-center"><?= htmlspecialchars($data['user_phone'] ?? 'N/A'); ?></td>
                <td class="text-center"><?= strtoupper($data['user_type'] ?? 'USER'); ?></td>
            <?php endif; ?>

            <td class="text-center"><?= number_format((float)$data['amount'], 2); ?></td>
            <td class="text-center"><?= number_format((float)$data['balance'], 2); ?></td>
            <td class="text-center"><?= htmlspecialchars($data['purpose']); ?></td>

            <td class="text-center">
                <strong class="<?= strtolower($data['type']) === 'credit' ? 'text-success' : 'text-danger'; ?>">
                    <?= strtoupper($data['type']); ?>
                </strong>
            </td>

            <td class="text-center">
                <?= $data['status'] == '1' ? '<span class="badge bg-success">SUCCESS</span>' : '<span class="badge bg-danger">FAILED</span>'; ?>
            </td>

            <td class="text-center"><?= date('d-m-Y h:i A', strtotime($data['date'])); ?></td>
        </tr>
<?php
    }
} else {
    echo '<tr><td colspan="12" class="text-center">No transactions found</td></tr>';
}
?>

                        </tbody>
                    </table>
                </div>

            </div>
        </div>
    </div>
</div>

<!--end page wrapper -->
<?php 
include('footer.php');
?>
<!-- Bootstrap JS -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<!--plugins-->
<script src="../template/ahkweb/assets/js/jquery.min.js"></script>
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/ahkweb/assets/plugins/chartjs/chart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-2.0.2.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-world-mill-en.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery.easy-pie-chart/jquery.easypiechart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/sparkline-charts/jquery.sparkline.min.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery-knob/excanvas.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery-knob/jquery.knob.js"></script>
<script>
$(function() {
    $(".knob").knob();
});
</script>
<script src="../template/ahkweb/assets/js/index.js"></script>
<!--app JS-->
<script src="../template/ahkweb/assets/js/app.js"></script>
<!-- datatable -->
<script src="../template/ahkweb/assets/plugins/datatable/js/jquery.dataTables.min.js"></script>
	<script src="../template/ahkweb/assets/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
<script>
		$(document).ready(function() {
			$('#example').DataTable();
            $('#aadh').inputmask();
		  } );
	</script>
	
	<script>
		$(document).ready(function() {
			var table = $('#example2').DataTable( {
				lengthChange: false,
				buttons: [ 'copy', 'excel', 'pdf', 'print']
			} );
		 
			table.buttons().container()
				.appendTo( '#example2_wrapper .col-md-6:eq(0)' );
		} );


	</script>
	
</body>



</html>