<?php
require_once("../includes/session.php");
require_once("../includes/config.php");

include('header.php');

$user_email = $udata['email'];

// Mark messages as read
mysqli_query($ahk_conn, "UPDATE contact SET is_read_user=1 WHERE email='$user_email' AND reply IS NOT NULL");

$messagesQuery = mysqli_query($ahk_conn, "SELECT * FROM contact WHERE email='$user_email' ORDER BY created_at DESC");
?>

<style>
.message-card {
    background: white;
    border-radius: 12px;
    padding: 20px;
    margin-bottom: 15px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}
.reply-box {
    background: #e8f5e9;
    border-left: 4px solid #4caf50;
    padding: 15px;
    border-radius: 8px;
    margin-top: 15px;
}
</style>

<div class="page-wrapper">
    <div class="page-content">
        <h3 class="mb-4"><i class="fas fa-envelope"></i> My Messages</h3>

        <?php if(mysqli_num_rows($messagesQuery) > 0): ?>
            <?php while($msg = mysqli_fetch_assoc($messagesQuery)): ?>
                <div class="message-card">
                    <div class="d-flex justify-content-between align-items-start mb-3">
                        <h6>Your Message</h6>
                        <small class="text-muted"><?php echo date('d M Y, h:i A', strtotime($msg['created_at'])); ?></small>
                    </div>
                    
                    <p class="mb-0"><?php echo nl2br(htmlspecialchars($msg['mess'])); ?></p>

                    <?php if(!empty($msg['reply'])): ?>
                        <div class="reply-box">
                            <strong><i class="fas fa-reply"></i> Admin Reply:</strong>
                            <p class="mb-0 mt-2"><?php echo nl2br(htmlspecialchars($msg['reply'])); ?></p>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-info mt-3 mb-0">
                            <i class="fas fa-clock"></i> Waiting for admin response...
                        </div>
                    <?php endif; ?>
                </div>
            <?php endwhile; ?>
        <?php else: ?>
            <div class="alert alert-info text-center">
                <i class="fas fa-info-circle"></i> No messages yet!
            </div>
        <?php endif; ?>
    </div>
</div>

<?php include('../admin/footers.php'); ?>