<?php
require_once("../includes/session.php");
require_once("../includes/config.php");

include('header.php');

$newsQuery = mysqli_query($ahk_conn, "SELECT * FROM admin_news WHERE status='active' ORDER BY created_at DESC LIMIT 20");
?>

<style>
.news-page-wrapper {
    padding: 20px;
}

.news-header-banner {
    background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    color: white;
    padding: 40px 30px;
    border-radius: 20px;
    text-align: center;
    margin-bottom: 30px;
    box-shadow: 0 15px 35px rgba(102, 126, 234, 0.3);
    position: relative;
    overflow: hidden;
}

.news-header-banner::before {
    content: '';
    position: absolute;
    top: -50%;
    left: -50%;
    width: 200%;
    height: 200%;
    background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%);
    animation: rotate 20s linear infinite;
}

@keyframes rotate {
    from { transform: rotate(0deg); }
    to { transform: rotate(360deg); }
}

.news-header-banner h1 {
    margin: 0;
    font-size: 32px;
    font-weight: 700;
    position: relative;
    z-index: 1;
}

.news-header-banner p {
    margin: 10px 0 0;
    font-size: 16px;
    opacity: 0.9;
    position: relative;
    z-index: 1;
}

.news-card {
    background: white;
    border-radius: 20px;
    padding: 0;
    margin-bottom: 25px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
    transition: all 0.4s ease;
    overflow: hidden;
    border: 1px solid rgba(0,0,0,0.05);
}

.news-card:hover {
    box-shadow: 0 20px 50px rgba(0,0,0,0.15);
    transform: translateY(-8px);
}

.news-card-header {
    background: linear-gradient(135deg, #f8f9fa 0%, #e9ecef 100%);
    padding: 20px 25px;
    border-bottom: 1px solid rgba(0,0,0,0.05);
    display: flex;
    align-items: center;
    justify-content: space-between;
}

.news-date {
    display: flex;
    align-items: center;
    gap: 10px;
    color: #666;
    font-size: 14px;
}

.news-date i {
    color: #667eea;
    font-size: 18px;
}

.news-badge {
    background: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
    color: white;
    padding: 5px 15px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
}

.news-card-body {
    padding: 25px;
}

.news-title {
    font-size: 22px;
    font-weight: 700;
    color: #2d3436;
    margin-bottom: 15px;
    line-height: 1.4;
}

.news-content {
    color: #636e72;
    line-height: 1.8;
    font-size: 15px;
}

.news-empty {
    text-align: center;
    padding: 60px 30px;
    background: white;
    border-radius: 20px;
    box-shadow: 0 10px 30px rgba(0,0,0,0.08);
}

.news-empty i {
    font-size: 80px;
    color: #dfe6e9;
    margin-bottom: 20px;
}

.news-empty h4 {
    color: #636e72;
    margin-bottom: 10px;
}

.news-empty p {
    color: #b2bec3;
}

/* Responsive */
@media (max-width: 768px) {
    .news-header-banner {
        padding: 30px 20px;
    }
    .news-header-banner h1 {
        font-size: 24px;
    }
    .news-card-body {
        padding: 20px;
    }
    .news-title {
        font-size: 18px;
    }
}
</style>

<div class="page-wrapper">
    <div class="page-content news-page-wrapper">
        
        <div class="news-header-banner">
            <h1><i class="fas fa-newspaper"></i> Latest News & Updates</h1>
            <p>Stay updated with important announcements and information</p>
        </div>

        <?php if(mysqli_num_rows($newsQuery) > 0): ?>
            <?php while($news = mysqli_fetch_assoc($newsQuery)): ?>
                <div class="news-card">
                    <div class="news-card-header">
                        <div class="news-date">
                            <i class="fas fa-calendar-alt"></i>
                            <span><?php echo date('d M Y, h:i A', strtotime($news['created_at'])); ?></span>
                        </div>
                        <span class="news-badge"><i class="fas fa-bell"></i> New</span>
                    </div>
                    <div class="news-card-body">
                        <div class="news-title"><?php echo htmlspecialchars($news['title']); ?></div>
                        <div class="news-content"><?php echo nl2br(htmlspecialchars($news['content'])); ?></div>
                    </div>
                </div>
            <?php endwhile; ?>
        <?php else: ?>
            <div class="news-empty">
                <i class="fas fa-newspaper"></i>
                <h4>No News Available</h4>
                <p>Check back later for updates and announcements.</p>
            </div>
        <?php endif; ?>
        
    </div>
</div>

<?php include('../admin/footers.php'); ?>