<?php
checkSession();

$activeManualServices = [];
$servicesQuery = mysqli_query($ahk_conn, "SELECT * FROM service_management WHERE status='YES' ORDER BY sort_order ASC");
while($svc = mysqli_fetch_assoc($servicesQuery)) {
    $userColumn = $svc['user_column'];
    if (isset($udata[$userColumn]) && $udata[$userColumn] == 'YES') {
        $activeManualServices[] = $svc;
    }
}

$unreadNews = mysqli_num_rows(mysqli_query($ahk_conn, "SELECT id FROM admin_news WHERE status='active' AND DATE(created_at) >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)"));

if(checkAdmin($udata['type'])) {
    $unreadMessages = mysqli_num_rows(mysqli_query($ahk_conn, "SELECT id FROM contact WHERE is_read=0"));
} else {
    $unreadMessages = mysqli_num_rows(mysqli_query($ahk_conn, "SELECT id FROM contact WHERE email='".$udata['email']."' AND reply IS NOT NULL AND is_read_user=0"));
}

$defaultProfilePic = "../admin/uploads/Profile-Male-PNG.png";
$userProfilePic = $defaultProfilePic;
if(isset($udata['profile_pic']) && !empty($udata['profile_pic']) && file_exists("../admin/uploads/profiles/".$udata['profile_pic'])) {
    $userProfilePic = "../admin/uploads/profiles/".$udata['profile_pic'];
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo ahkweb('logo'); ?>">
    <link href="../template/ahkweb/assets/plugins/simplebar/css/simplebar.css" rel="stylesheet" />
    <link href="../template/ahkweb/assets/plugins/perfect-scrollbar/css/perfect-scrollbar.css" rel="stylesheet" />
    <link href="../template/ahkweb/assets/plugins/metismenu/css/metisMenu.min.css" rel="stylesheet" />
    <link href="../template/ahkweb/assets/css/pace.min.css" rel="stylesheet" />
    <script src="../template/ahkweb/assets/js/pace.min.js"></script>
    <link href="../template/ahkweb/assets/css/bootstrap.min.css" rel="stylesheet">
    <link href="../template/ahkweb/assets/css/bootstrap-extended.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600;700&display=swap" rel="stylesheet">
    <link href="../template/ahkweb/assets/css/app.css" rel="stylesheet">
    <link href="../template/ahkweb/assets/css/icons.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <title>Dashboard | <?php echo ahkweb('webname'); ?></title>
    
<style>
:root {
    --primary-gradient: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    --success-gradient: linear-gradient(135deg, #11998e 0%, #38ef7d 100%);
    --danger-gradient: linear-gradient(135deg, #ff416c 0%, #ff4b2b 100%);
    --sidebar-bg: linear-gradient(180deg, #1a1c2e 0%, #2d1f3d 100%);
}

* { font-family: 'Poppins', sans-serif; }

.sidebar-wrapper {
    background: var(--sidebar-bg) !important;
    box-shadow: 4px 0 25px rgba(0,0,0,0.15);
}

/* Force Dark Background on All Sidebar Elements */
.sidebar-wrapper *,
.sidebar-wrapper ul,
.sidebar-wrapper li,
.sidebar-wrapper .collapse,
.sidebar-wrapper .collapsing {
    background-color: transparent !important;
}

.sidebar-wrapper .submenu-list,
.sidebar-wrapper .mm-collapse,
.sidebar-wrapper ul ul {
    background: rgba(0,0,0,0.35) !important;
    border-radius: 10px;
    margin: 8px 12px;
    padding: 8px 0;
    border: 1px solid rgba(255,255,255,0.08);
}

.sidebar-header {
    background: rgba(255,255,255,0.05);
    padding: 20px 15px;
    border-bottom: 1px solid rgba(255,255,255,0.1);
}

.logo-text { color: #fff !important; font-weight: 700; font-size: 16px; }

.metismenu li a {
    color: rgba(255,255,255,0.8) !important;
    padding: 12px 20px;
    margin: 3px 10px;
    border-radius: 10px;
    transition: all 0.3s ease;
}

.metismenu li a:hover,
.metismenu li.mm-active > a {
    background: rgba(255,255,255,0.1) !important;
    color: #fff !important;
    transform: translateX(5px);
}

.metismenu .has-arrow::after { border-color: rgba(255,255,255,0.6) !important; }

.metismenu ul {
    background: rgba(0,0,0,0.2);
    border-radius: 10px;
    margin: 5px 15px;
    padding: 10px 0;
}

.metismenu ul li a {
    padding: 8px 15px !important;
    margin: 2px 5px !important;
    font-size: 13px;
}

.metismenu ul li a:hover { background: rgba(102,126,234,0.3) !important; }

.menu-label {
    color: rgba(255,255,255,0.5) !important;
    font-size: 11px;
    font-weight: 600;
    letter-spacing: 1px;
    padding: 15px 20px 8px !important;
    text-transform: uppercase;
}

/* Submenu Dropdown Styles */
.submenu-list {
    background: rgba(0,0,0,0.3) !important;
    border-radius: 10px;
    margin: 5px 15px;
    padding: 10px 0;
    list-style: none;
    border: 1px solid rgba(255,255,255,0.1);
}

.submenu-list li {
    background: transparent !important;
}

.submenu-list li a {
    padding: 10px 20px !important;
    margin: 2px 8px !important;
    font-size: 13px;
    display: block;
    color: rgba(255,255,255,0.8) !important;
    text-decoration: none;
    border-radius: 8px;
    transition: all 0.3s ease;
    background: transparent !important;
}

.submenu-list li a:hover {
    background: rgba(102,126,234,0.4) !important;
    color: #fff !important;
    transform: translateX(5px);
}

.submenu-list li a i {
    margin-right: 8px;
    color: rgba(255,255,255,0.6);
}

/* Override Bootstrap Collapse Styles */
.collapse.submenu-list,
.collapsing.submenu-list {
    background: rgba(0,0,0,0.3) !important;
}

/* MetisMenu Override */
.metismenu ul {
    background: rgba(0,0,0,0.3) !important;
    border-radius: 10px;
    margin: 5px 15px;
    padding: 10px 0;
    border: 1px solid rgba(255,255,255,0.1);
}

.metismenu ul li {
    background: transparent !important;
}

.metismenu ul li a {
    background: transparent !important;
    color: rgba(255,255,255,0.8) !important;
}

.metismenu ul li a:hover {
    background: rgba(102,126,234,0.4) !important;
    color: #fff !important;
}

.mm-collapse {
    background: rgba(0,0,0,0.3) !important;
}

.has-arrow::after {
    content: '';
    border-style: solid;
    border-width: 0 2px 2px 0;
    border-color: rgba(255,255,255,0.6);
    display: inline-block;
    padding: 3px;
    transform: rotate(45deg);
    position: absolute;
    right: 20px;
    top: 50%;
    margin-top: -5px;
    transition: all 0.3s ease;
}

.has-arrow[aria-expanded="true"]::after,
.has-arrow:not(.collapsed)::after {
    transform: rotate(-135deg);
    margin-top: -2px;
}

.metismenu li {
    position: relative;
}

.badge-instant {
    background: var(--success-gradient);
    color: #fff;
    font-size: 9px;
    padding: 3px 8px;
    border-radius: 20px;
    margin-left: 8px;
    font-weight: 600;
}

.badge-count {
    background: var(--danger-gradient);
    color: #fff;
    padding: 3px 8px;
    border-radius: 20px;
    font-size: 10px;
    margin-left: 8px;
    font-weight: 600;
    animation: pulse 2s infinite;
}

@keyframes pulse {
    0%, 100% { transform: scale(1); }
    50% { transform: scale(1.1); }
}

.news-pulse { animation: glow 1.5s infinite; }

@keyframes glow {
    0%, 100% { opacity: 1; text-shadow: 0 0 5px #f39c12; }
    50% { opacity: 0.7; text-shadow: 0 0 20px #f39c12; }
}

.topbar {
    background: #fff !important;
    box-shadow: 0 4px 20px rgba(0,0,0,0.08);
    padding: 10px 20px;
}

.wallet-btn {
    background: var(--primary-gradient);
    border: none;
    padding: 10px 20px;
    border-radius: 50px;
    color: #fff;
    font-weight: 600;
    display: flex;
    align-items: center;
    gap: 8px;
    box-shadow: 0 4px 15px rgba(102,126,234,0.4);
    transition: all 0.3s ease;
    text-decoration: none;
}

.wallet-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 6px 25px rgba(102,126,234,0.5);
    color: #fff;
}

.user-img {
    width: 45px;
    height: 45px;
    border-radius: 50%;
    object-fit: cover;
    border: 3px solid transparent;
    background: linear-gradient(white, white) padding-box, var(--primary-gradient) border-box;
    cursor: pointer;
    transition: all 0.3s ease;
}

.user-img:hover {
    transform: scale(1.1);
    box-shadow: 0 5px 20px rgba(102,126,234,0.4);
}

.user-box .dropdown-menu {
    border: none;
    border-radius: 15px;
    box-shadow: 0 10px 40px rgba(0,0,0,0.15);
    padding: 15px;
    min-width: 280px;
}

.profile-header {
    text-align: center;
    padding: 20px 10px;
    background: var(--primary-gradient);
    border-radius: 12px;
    margin-bottom: 15px;
}

.profile-header img {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    border: 4px solid rgba(255,255,255,0.3);
    object-fit: cover;
    margin-bottom: 10px;
}

.profile-header h6 { color: #fff; margin: 0; font-weight: 600; }
.profile-header small { color: rgba(255,255,255,0.8); }

.upload-profile-btn {
    background: rgba(255,255,255,0.2);
    color: #fff;
    border: 2px dashed rgba(255,255,255,0.5);
    padding: 8px 15px;
    border-radius: 25px;
    font-size: 12px;
    margin-top: 10px;
    cursor: pointer;
    transition: all 0.3s ease;
    display: inline-block;
}

.upload-profile-btn:hover {
    background: rgba(255,255,255,0.3);
    border-color: #fff;
}

.dropdown-item {
    padding: 12px 15px;
    border-radius: 10px;
    transition: all 0.3s ease;
}

.dropdown-item:hover {
    background: #f8f9fa;
    transform: translateX(5px);
}

.dropdown-item i { width: 25px; color: #667eea; }

#time {
    background: linear-gradient(135deg, #232526, #414345);
    color: #fff;
    font-size: 12px;
    font-weight: 500;
    padding: 8px 15px;
    border-radius: 25px;
}

@media (max-width: 768px) { #time { display: none; } }

.theme-switcher {
    position: fixed;
    top: 50%;
    right: 0;
    transform: translateY(-50%);
    z-index: 9999;
    background: #fff;
    border-radius: 15px 0 0 15px;
    box-shadow: -5px 0 25px rgba(0,0,0,0.15);
    padding: 15px 10px;
}

.theme-btn {
    display: block;
    width: 45px;
    height: 45px;
    border: none;
    border-radius: 12px;
    margin-bottom: 10px;
    cursor: pointer;
    font-size: 20px;
    transition: all 0.3s ease;
}

.theme-btn:hover { transform: scale(1.15); }
.theme-btn.active { box-shadow: 0 0 0 3px #667eea; }
.theme-btn:last-child { margin-bottom: 0; }
.theme-day { background: linear-gradient(135deg, #ffeaa7, #fdcb6e); }
.theme-night { background: linear-gradient(135deg, #2d3436, #000); color: #fff; }
.theme-bw { background: linear-gradient(135deg, #dfe6e9, #636e72); }

body.night-theme { background: #0f0f1a !important; color: #eee !important; }
.night-theme .sidebar-wrapper { background: linear-gradient(180deg, #0a0a15 0%, #1a1a2e 100%) !important; }
.night-theme .topbar { background: #1a1a2e !important; }
.night-theme .card, .night-theme .dashboard-card, .night-theme .service-card, .night-theme .services-box {
    background: #1a1a2e !important;
    color: #eee !important;
}
.night-theme .page-content { background: #0f0f1a !important; }
body.bw-theme * { filter: grayscale(100%) !important; }

.notification-bell {
    position: relative;
    width: 45px;
    height: 45px;
    background: #f8f9fa;
    border-radius: 12px;
    display: flex;
    align-items: center;
    justify-content: center;
    cursor: pointer;
    transition: all 0.3s ease;
}

.notification-bell:hover { background: #e9ecef; transform: scale(1.05); }
.notification-bell i { font-size: 20px; color: #333; }

.alert-count {
    position: absolute;
    top: -5px;
    right: -5px;
    background: var(--danger-gradient);
    color: #fff;
    font-size: 10px;
    font-weight: 600;
    padding: 3px 7px;
    border-radius: 20px;
    min-width: 20px;
    text-align: center;
}

#page-loader {
    position: fixed;
    top: 0;
    left: 0;
    width: 100vw;
    height: 100vh;
    background: rgba(0,0,0,0.7);
    z-index: 99999;
    display: none;
    justify-content: center;
    align-items: center;
    backdrop-filter: blur(5px);
}

.loader-spinner {
    width: 60px;
    height: 60px;
    border: 4px solid rgba(255,255,255,0.2);
    border-top: 4px solid #667eea;
    border-radius: 50%;
    animation: spin 1s linear infinite;
}

@keyframes spin { to { transform: rotate(360deg); } }

.profile-upload-modal {
    display: none;
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0,0,0,0.8);
    z-index: 99999;
    justify-content: center;
    align-items: center;
    backdrop-filter: blur(10px);
}

.profile-upload-box {
    background: #fff;
    border-radius: 20px;
    padding: 30px;
    max-width: 400px;
    width: 90%;
    text-align: center;
    animation: slideUp 0.3s ease;
}

@keyframes slideUp {
    from { opacity: 0; transform: translateY(50px); }
    to { opacity: 1; transform: translateY(0); }
}

.profile-preview {
    width: 150px;
    height: 150px;
    border-radius: 50%;
    object-fit: cover;
    border: 5px solid #f0f0f0;
    margin-bottom: 20px;
}

.file-input-wrapper {
    position: relative;
    overflow: hidden;
    display: inline-block;
    margin-bottom: 15px;
}

.file-input-wrapper input[type="file"] {
    position: absolute;
    left: 0;
    top: 0;
    opacity: 0;
    cursor: pointer;
    width: 100%;
    height: 100%;
}

.file-input-btn {
    background: var(--primary-gradient);
    color: #fff;
    padding: 12px 30px;
    border-radius: 25px;
    font-weight: 600;
    cursor: pointer;
}
</style>
</head>

<body class="day-theme">

<!-- Theme Switcher -->
<div class="theme-switcher">
    <button class="theme-btn theme-day active" onclick="setTheme('day')" title="Day">☀️</button>
    <button class="theme-btn theme-night" onclick="setTheme('night')" title="Night">🌙</button>
    <button class="theme-btn theme-bw" onclick="setTheme('bw')" title="B&W">⚫</button>
</div>

<!-- Profile Upload Modal -->
<div class="profile-upload-modal" id="profileModal">
    <div class="profile-upload-box">
        <h5><i class="fas fa-camera"></i> Update Profile Picture</h5>
        <img src="<?php echo $userProfilePic; ?>" class="profile-preview" id="profilePreview">
        <form action="update_profile_pic.php" method="POST" enctype="multipart/form-data" id="profileForm">
            <div class="file-input-wrapper">
                <span class="file-input-btn"><i class="fas fa-upload"></i> Choose Photo</span>
                <input type="file" name="profile_pic" id="profileInput" accept="image/*" onchange="previewImage(this)">
            </div>
            <br><br>
            <button type="submit" class="btn btn-success btn-lg px-5" style="border-radius:25px">
                <i class="fas fa-check"></i> Save
            </button>
            <button type="button" class="btn btn-secondary btn-lg px-4" style="border-radius:25px" onclick="closeProfileModal()">
                <i class="fas fa-times"></i> Cancel
            </button>
        </form>
    </div>
</div>

<script>
function setTheme(t) {
    document.body.className = t + '-theme';
    localStorage.setItem('portalTheme', t);
    document.querySelectorAll('.theme-btn').forEach(b => b.classList.remove('active'));
    document.querySelector('.theme-' + t).classList.add('active');
}

window.addEventListener('load', function() {
    setTheme(localStorage.getItem('portalTheme') || 'day');
});

function openProfileModal() { document.getElementById('profileModal').style.display = 'flex'; }
function closeProfileModal() { document.getElementById('profileModal').style.display = 'none'; }

function previewImage(i) {
    if (i.files && i.files[0]) {
        var r = new FileReader();
        r.onload = function(e) { document.getElementById('profilePreview').src = e.target.result; };
        r.readAsDataURL(i.files[0]);
    }
}

document.getElementById('profileModal').addEventListener('click', function(e) {
    if (e.target === this) closeProfileModal();
});
</script>

<script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>

<div class="wrapper">
    <div class="sidebar-wrapper" data-simplebar="true">
        <div class="sidebar-header">
            <div><img src="<?php echo ahkweb('logo'); ?>" class="logo-icon" alt="logo"></div>
            <div>
                <h4 class="logo-text">
                    <?php
                    ob_start();
                    ahkweb('webname');
                    $w = ob_get_clean();
                    $ws = explode(' ', trim($w));
                    echo isset($ws[1]) ? $ws[0] . ' ' . $ws[1] : $ws[0];
                    ?>
                </h4>
            </div>
            <div class="toggle-icon ms-auto"><i class="bx bx-menu"></i></div>
        </div>

        <ul class="metismenu" id="menu">
            <li>
                <a href="index">
                    <div class="parent-icon"><i class="fas fa-home text-danger"></i></div>
                    <div class="menu-title">Dashboard</div>
                </a>
            </li>

            <?php if (checkAdmin($udata['type']) == true) { ?>
            <li>
                <a href="#userManagementAdmin" data-bs-toggle="collapse" class="has-arrow">
                    <div class="parent-icon"><i class="fas fa-users text-primary"></i></div>
                    <div class="menu-title">User Management</div>
                </a>
                <ul id="userManagementAdmin" class="collapse submenu-list">
                    <li><a href="users"><i class="bx bx-right-arrow-alt"></i>All Users</a></li>
                    <li><a href="adduser"><i class="bx bx-right-arrow-alt"></i>Add New</a></li>
                    <li><a href="qrpay_pending"><i class="bx bx-right-arrow-alt"></i>QR Pending</a></li>
                    <li><a href="PendingManualUsers"><i class="bx bx-right-arrow-alt"></i>Manual Pending</a></li>
                    <li><a href="BalanceTransfer"><i class="bx bx-right-arrow-alt"></i>Balance Transfer</a></li>
                </ul>
            </li>
            <?php } ?>

            <?php if ($udata['type'] == "distributor" || $udata['type'] == "super_dist") { ?>
            <li>
                <a href="#userManagementDist" data-bs-toggle="collapse" class="has-arrow">
                    <div class="parent-icon"><i class="bx bx-user text-info"></i></div>
                    <div class="menu-title">User Management</div>
                </a>
                <ul id="userManagementDist" class="collapse submenu-list">
                    <li><a href="adduser"><i class="bx bx-right-arrow-alt"></i>Add New</a></li>
                    <li><a href="myusers"><i class="bx bx-right-arrow-alt"></i>My Users</a></li>
                </ul>
            </li>
            <?php } ?>

            <li>
                <a href="wallet">
                    <div class="parent-icon"><i class="fas fa-wallet text-success"></i></div>
                    <div class="menu-title">Add Wallet <span class="badge-instant">Instant</span></div>
                </a>
            </li>

            <li>
                <a href="print_history.php">
                    <div class="parent-icon"><i class="fas fa-history text-info"></i></div>
                    <div class="menu-title">Print History</div>
                </a>
            </li>

            <li>
                <a href="news_updates.php">
                    <div class="parent-icon">
                        <i class="fas fa-newspaper text-warning <?php echo $unreadNews > 0 ? 'news-pulse' : ''; ?>"></i>
                    </div>
                    <div class="menu-title">
                        Today News
                        <?php if($unreadNews > 0): ?>
                        <span class="badge-count"><?php echo $unreadNews; ?></span>
                        <?php endif; ?>
                    </div>
                </a>
            </li>

            <li class="menu-label">📱 All Services</li>

            <li><a href="Uid_Flx-Services"><div class="parent-icon"><img src="../images/aadhaar_icon.jpg" width="28" style="border-radius:5px"></div><div class="menu-title">Aadhaar Services</div></a></li>
            <li><a href="pan_card_service"><div class="parent-icon"><img src="../admin/uploads/Services/panservices.png" width="28" style="border-radius:5px"></div><div class="menu-title">Pan Card Services</div></a></li>
            <li><a href="vahicle_card_service"><div class="parent-icon"><img src="../admin/uploads/Services/Yamaha-Bike-PNG.png" width="28" style="border-radius:5px"></div><div class="menu-title">Vehicle Services</div></a></li>
            <li><a href="Voter_card_service"><div class="parent-icon"><img src="../admin/uploads/Services/voter.png" width="28" style="border-radius:5px"></div><div class="menu-title">Voter Services</div></a></li>
            <li><a href="Ration_card_service"><div class="parent-icon"><img src="../admin/uploads/Services/ration1.png" width="28" style="border-radius:5px"></div><div class="menu-title">Ration Services</div></a></li>
            <li><a href="ElectriBill_card_service"><div class="parent-icon"><img src="../admin/uploads/Services/electricBill.png" width="28" style="border-radius:5px"></div><div class="menu-title">Electric Bill</div></a></li>
            <li><a href="FarmerStackService"><div class="parent-icon"><img src="../admin/uploads/Services/farmerLogo0.png" width="28" style="border-radius:5px"></div><div class="menu-title">Farmer Services</div></a></li>
            <li><a href="Passbook_card_service"><div class="parent-icon"><img src="../admin/uploads/Services/1771198.png" width="28" style="border-radius:5px"></div><div class="menu-title">Passbook Services</div></a></li>
            <li><a href="Other_card_service"><div class="parent-icon"><img src="../admin/uploads/Services/dlpng.png" width="28" style="border-radius:5px"></div><div class="menu-title">Other Services</div></a></li>

            <?php if (!empty($activeManualServices)): ?>
            <li class="menu-label">⚡ Premium Services</li>
            <?php 
            $serviceIcons = [
                'll_apply_fee' => ['icon' => 'fa-car-side', 'color' => '#e74c3c'],
                'mobile_lookup_fee' => ['icon' => 'fa-mobile-alt', 'color' => '#3498db'],
                'aadhaar_lookup_fee' => ['icon' => 'fa-fingerprint', 'color' => '#9b59b6'],
                'voter_direct_pdf_fee' => ['icon' => 'fa-vote-yea', 'color' => '#e67e22'],
                'voter_mobile_link_fee' => ['icon' => 'fa-link', 'color' => '#1abc9c'],
                'puc_bike_fee' => ['icon' => 'fa-certificate', 'color' => '#16a085'],
                'puc_car_fee' => ['icon' => 'fa-certificate', 'color' => '#16a085'],
                'dl_to_mobile_fee' => ['icon' => 'fa-id-card', 'color' => '#2980b9'],
                'pan_aadhaar_otp_fee' => ['icon' => 'fa-file-invoice', 'color' => '#d35400'],
                'tec_exam_fee' => ['icon' => 'fa-graduation-cap', 'color' => '#27ae60'],
            ];
            
            foreach($activeManualServices as $svc): 
                $counts = '';
                $tableName = '';
                switch($svc['service_key']) {
                    case 'll_apply_fee': $tableName = 'll_requests'; break;
                    case 'puc_bike_fee': case 'puc_car_fee': $tableName = 'puc_requests'; break;
                    case 'voter_direct_pdf_fee': $tableName = 'voter_direct_pdf_requests'; break;
                    case 'voter_mobile_link_fee': $tableName = 'voter_mobile_link_requests'; break;
                    case 'dl_to_mobile_fee': $tableName = 'dl_to_mobile_requests'; break;
                    case 'pan_aadhaar_otp_fee': $tableName = 'pan_aadhaar_otp_requests'; break;
                    case 'tec_exam_fee': $tableName = 'tec_exam_requests'; break;
                }
                if(!empty($tableName)) {
                    $pending = mysqli_num_rows(mysqli_query($ahk_conn, "SELECT id FROM $tableName WHERE status='Pending'"));
                    if($pending > 0) $counts = "<span class='badge-count'>$pending</span>";
                }
                $iconData = $serviceIcons[$svc['service_key']] ?? ['icon' => 'fa-bolt', 'color' => '#f39c12'];
            ?>
            <li>
                <a href="<?php echo $svc['sidebar_link']; ?>">
                    <div class="parent-icon"><i class="fas <?php echo $iconData['icon']; ?>" style="color:<?php echo $iconData['color']; ?>"></i></div>
                    <div class="menu-title"><?php echo $svc['display_name'] . $counts; ?></div>
                </a>
            </li>
            <?php endforeach; ?>
            <?php endif; ?>

            <li class="menu-label">📊 Reports & Help</li>
            <li><a href="wallet_history"><div class="parent-icon"><i class="fas fa-history text-info"></i></div><div class="menu-title">Wallet Record</div></a></li>
            <li><a href="complaint_request"><div class="parent-icon"><i class="fas fa-exclamation-circle text-warning"></i></div><div class="menu-title">Complaint Rise</div></a></li>
            <li><a href="complaint_request_list"><div class="parent-icon"><i class="fas fa-headset text-danger"></i></div><div class="menu-title">Complaint List</div></a></li>
            <li><a href="pricing_list"><div class="parent-icon"><i class="fas fa-rupee-sign text-success"></i></div><div class="menu-title">Pricing</div></a></li>

            <?php if (checkAdmin($udata['type']) == true) { ?>
            <li class="menu-label">⚙️ Admin Panel</li>
            
            <li>
                <a href="#serviceManagement" data-bs-toggle="collapse" class="has-arrow">
                    <div class="parent-icon"><i class="fas fa-cogs text-primary"></i></div>
                    <div class="menu-title">Service Management</div>
                </a>
                <ul id="serviceManagement" class="collapse submenu-list">
                    <li><a href="service_management"><i class="bx bx-right-arrow-alt"></i>Manage Services</a></li>
                    <?php foreach($activeManualServices as $svc): 
                        $adminLink = str_replace('.php', '_admin.php', $svc['sidebar_link']);
                    ?>
                    <li><a href="<?php echo $adminLink; ?>"><i class="bx bx-right-arrow-alt"></i><?php echo str_replace(' Request', '', $svc['display_name']); ?></a></li>
                    <?php endforeach; ?>
                </ul>
            </li>

            <li><a href="news_admin"><div class="parent-icon"><i class="fas fa-newspaper text-warning"></i></div><div class="menu-title">Manage News</div></a></li>
            <li><a href="messages_admin"><div class="parent-icon"><i class="fas fa-envelope text-info"></i></div><div class="menu-title">Messages <?php if($unreadMessages > 0): ?><span class="badge-count"><?php echo $unreadMessages; ?></span><?php endif; ?></div></a></li>
            <li><a href="complaint_request_list_admin"><div class="parent-icon"><i class="fas fa-headset text-info"></i></div><div class="menu-title">Complaint Admin</div></a></li>
            
            <li>
                <a href="#settingsMenu" data-bs-toggle="collapse" class="has-arrow">
                    <div class="parent-icon"><i class="fas fa-cog text-secondary"></i></div>
                    <div class="menu-title">Settings</div>
                </a>
                <ul id="settingsMenu" class="collapse submenu-list">
                    <li><a href="pricing"><i class="bx bx-right-arrow-alt"></i>Pricing</a></li>
                    <li><a href="LogoUpdate"><i class="bx bx-right-arrow-alt"></i>Logo Update</a></li>
                    <li><a href="settings"><i class="bx bx-right-arrow-alt"></i>Website Details</a></li>
                </ul>
            </li>
            <?php } ?>

            <li><a href="referral"><div class="parent-icon"><i class="fas fa-gift text-warning"></i></div><div class="menu-title">Refer & Earn</div></a></li>
            <li><a href="../includes/logout.php"><div class="parent-icon"><i class="fas fa-sign-out-alt text-danger"></i></div><div class="menu-title">Logout</div></a></li>
        </ul>
    </div>

    <header>
        <div class="topbar d-flex align-items-center">
            <nav class="navbar navbar-expand gap-3">
                <div class="mobile-toggle-menu"><i class='bx bx-menu' style="font-size:24px"></i></div>
                
                <?php
                if (isset($_GET['gettoAdmin']) && $_GET['session'] == 'true') {
                    loginAsAdmin();
                }

                if (isset($_SESSION['adminasuser']) == true && $_SESSION['adminusername'] != NULL) {
                ?>
                <div class="search-bar flex-grow-1">
                    <a href="?gettoAdmin=1&session=true" class="btn btn-success btn-sm px-4" style="border-radius:25px">
                        <i class="fas fa-arrow-left"></i> Back to Admin
                    </a>
                </div>
                <?php } else { ?>
                <div class="search-bar flex-grow-1 d-none d-lg-block">
                    <div class="position-relative search-bar-box">
                        <input type="text" class="form-control" placeholder="Quick notepad..." style="background:#f8f9fa;border:none;border-radius:25px;padding:12px 20px">
                        <span class="position-absolute top-50 translate-middle-y" style="right:15px">
                            <i class='bx bx-notepad' style="font-size:20px;color:#999"></i>
                        </span>
                    </div>
                </div>
                <?php } ?>
                
                <div class="d-none d-md-block">
                    <span id="time"></span>
                    <script>
                        function refreshTime() {
                            let n = new Date();
                            let d = String(n.getDate()).padStart(2, '0');
                            let m = String(n.getMonth() + 1).padStart(2, '0');
                            let y = n.getFullYear();
                            let h = n.getHours();
                            let mi = String(n.getMinutes()).padStart(2, '0');
                            let s = String(n.getSeconds()).padStart(2, '0');
                            let ap = h >= 12 ? 'PM' : 'AM';
                            h = h % 12 || 12;
                            document.getElementById("time").innerHTML = `📅 ${d}-${m}-${y} | ⏰ ${h}:${mi}:${s} ${ap}`;
                        }
                        refreshTime();
                        setInterval(refreshTime, 1000);
                    </script>
                </div>
                
                <a href="wallet" class="wallet-btn">
                    <i class="fas fa-wallet"></i>
                    <span>₹<?= number_format($udata['balance'], 2) ?></span>
                </a>

                <div class="top-menu ms-auto">
                    <ul class="navbar-nav align-items-center gap-2">
                        <li class="nav-item dropdown">
                            <a class="notification-bell" href="#" data-bs-toggle="dropdown">
                                <?php if($unreadMessages > 0): ?>
                                <span class="alert-count"><?php echo $unreadMessages; ?></span>
                                <?php endif; ?>
                                <i class='bx bx-envelope'></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-end" style="min-width:250px;border-radius:15px;padding:15px">
                                <h6 class="px-2 mb-3"><i class="fas fa-envelope text-primary"></i> Messages</h6>
                                <a class="dropdown-item" href="<?php echo checkAdmin($udata['type']) ? 'messages_admin' : 'user_messages'; ?>">
                                    <i class="fas fa-inbox"></i> View All
                                    <?php if($unreadMessages > 0): ?>
                                    <span class="badge bg-danger float-end"><?php echo $unreadMessages; ?></span>
                                    <?php endif; ?>
                                </a>
                            </div>
                        </li>
                        
                        <li class="nav-item dropdown">
                            <a class="notification-bell" href="#" data-bs-toggle="dropdown">
                                <?php if($unreadNews > 0): ?>
                                <span class="alert-count"><?php echo $unreadNews; ?></span>
                                <?php endif; ?>
                                <i class='bx bx-bell'></i>
                            </a>
                            <div class="dropdown-menu dropdown-menu-end" style="min-width:250px;border-radius:15px;padding:15px">
                                <h6 class="px-2 mb-3"><i class="fas fa-newspaper text-warning"></i> News</h6>
                                <a class="dropdown-item" href="news_updates.php">
                                    <i class="fas fa-external-link-alt"></i> View All
                                    <?php if($unreadNews > 0): ?>
                                    <span class="badge bg-warning float-end"><?php echo $unreadNews; ?></span>
                                    <?php endif; ?>
                                </a>
                            </div>
                        </li>
                    </ul>
                </div>
                
                <div class="user-box dropdown ms-3">
                    <a class="d-flex align-items-center nav-link dropdown-toggle dropdown-toggle-nocaret" href="#" data-bs-toggle="dropdown">
                        <img src="<?php echo $userProfilePic; ?>" class="user-img" alt="user">
                        <div class="user-info ps-3 d-none d-lg-block">
                            <p class="user-name mb-0" style="font-weight:600"><?php echo $udata['name']; ?></p>
                            <small class="text-muted"><?php echo ucfirst($udata['type']); ?></small>
                        </div>
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <div class="profile-header">
                            <img src="<?php echo $userProfilePic; ?>" alt="Profile">
                            <h6><?php echo $udata['name']; ?></h6>
                            <small><?php echo $udata['email']; ?></small>
                            <div>
                                <span class="upload-profile-btn" onclick="openProfileModal()">
                                    <i class="fas fa-camera"></i> Change Photo
                                </span>
                            </div>
                        </div>
                        <li><a class="dropdown-item" href="profile"><i class="bx bx-user"></i> My Profile</a></li>
                        <li><a class="dropdown-item" href="wallet"><i class="bx bx-wallet"></i> My Wallet</a></li>
                        <li><a class="dropdown-item" href="wallet_history"><i class="bx bx-history"></i> Transactions</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li><a class="dropdown-item text-danger" href="../includes/logout.php"><i class='bx bx-log-out-circle'></i> Logout</a></li>
                    </ul>
                </div>
            </nav>
        </div>
    </header>
    
    <div id="page-loader">
        <div class="loader-spinner"></div>
    </div>
    
    <script>
        window.addEventListener("load", () => document.getElementById("page-loader").style.display = "none");
        document.querySelectorAll("form").forEach(f => {
            f.addEventListener("submit", () => {
                if (f.id !== 'profileForm') document.getElementById("page-loader").style.display = "flex";
            });
        });
    </script>