<?php
require_once("../includes/session.php");
require_once("../includes/config.php");

if ($udata['voter_Mobile_Link_Service'] != "YES") {
    echo '<script>window.location="index.php";</script>';
    exit;
}

$records = mysqli_query($ahk_conn, "SELECT * FROM voter_mobile_link_requests WHERE username = '{$udata['name']}' ORDER BY id DESC");

$pendingCount = 0;
$processingCount = 0;
$successCount = 0;
$rejectedCount = 0;

$temp_records = mysqli_query($ahk_conn, "SELECT * FROM voter_mobile_link_requests WHERE username = '{$udata['name']}'");
while($rec = mysqli_fetch_assoc($temp_records)) {
    if($rec['status'] == 'Pending') $pendingCount++;
    elseif($rec['status'] == 'Processing') $processingCount++;
    elseif($rec['status'] == 'Success') $successCount++;
    elseif($rec['status'] == 'Rejected') $rejectedCount++;
}

include('../template/ahkweb/header.php');
?>

<style>
.stats-row { display:flex; gap:10px; margin-bottom:15px; flex-wrap:wrap; }
.stat-box { flex:1; min-width:70px; padding:12px 8px; border-radius:10px; text-align:center; color:#fff; }
.stat-box h3 { margin:0; font-size:22px; font-weight:700; }
.stat-box p { margin:5px 0 0; font-size:10px; }
.stat-pending { background:linear-gradient(135deg,#f39c12,#e67e22); }
.stat-processing { background:linear-gradient(135deg,#3498db,#2980b9); }
.stat-success { background:linear-gradient(135deg,#27ae60,#2ecc71); }
.stat-rejected { background:linear-gradient(135deg,#e74c3c,#c0392b); }

.status-badge { padding:5px 12px; border-radius:15px; font-size:11px; font-weight:600; }
.status-pending { background:#fff3cd; color:#856404; }
.status-processing { background:#cce5ff; color:#004085; }
.status-success { background:#d4edda; color:#155724; }
.status-rejected { background:#f8d7da; color:#721c24; }

.pulse { animation:pulse 1.5s infinite; }
@keyframes pulse { 0%,100%{opacity:1} 50%{opacity:0.5} }
</style>

<div class="page-wrapper">
    <div class="page-content">
        <div class="stats-row">
            <div class="stat-box stat-pending">
                <h3><?php echo $pendingCount; ?></h3>
                <p>⏳ Pending</p>
            </div>
            <div class="stat-box stat-processing">
                <h3><?php echo $processingCount; ?></h3>
                <p>🔄 Processing</p>
            </div>
            <div class="stat-box stat-success">
                <h3><?php echo $successCount; ?></h3>
                <p>✅ Success</p>
            </div>
            <div class="stat-box stat-rejected">
                <h3><?php echo $rejectedCount; ?></h3>
                <p>❌ Rejected</p>
            </div>
        </div>
        
        <div class="card">
            <div class="card-header bg-dark text-white py-2 d-flex justify-content-between">
                <span><i class="fas fa-history"></i> My Requests</span>
                <button class="btn btn-sm btn-light" onclick="location.reload()"><i class="fas fa-sync-alt"></i> Refresh</button>
            </div>
            <div class="card-body p-2">
                <?php if(mysqli_num_rows($records) > 0): ?>
                    <?php while($rec = mysqli_fetch_assoc($records)): 
                        $statusClass = strtolower($rec['status']);
                    ?>
                    <div class="card mb-2" style="border-radius:10px;box-shadow:0 2px 10px rgba(0,0,0,0.08);">
                        <div class="card-body py-2 px-3">
                            <div class="row align-items-center">
                                <div class="col-md-3 col-6 mb-1">
                                    <small class="text-muted">EPIC Number</small>
                                    <div><b><?php echo $rec['voter_epic_number']; ?></b></div>
                                </div>
                                <div class="col-md-3 col-6 mb-1">
                                    <small class="text-muted">Mobile Number</small>
                                    <div><b><?php echo $rec['mobile_number']; ?></b></div>
                                </div>
                                <div class="col-md-2 col-6 mb-1">
                                    <small class="text-muted">Amount</small>
                                    <div class="text-success"><b>₹<?php echo $rec['amount']; ?></b></div>
                                </div>
                                <div class="col-md-2 col-6 mb-1">
                                    <small class="text-muted">Status</small>
                                    <div>
                                        <span class="status-badge status-<?php echo $statusClass; ?>">
                                            <?php if($rec['status']=='Pending' || $rec['status']=='Processing'): ?>
                                            <span class="pulse">●</span>
                                            <?php endif; ?>
                                            <?php echo $rec['status']; ?>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-md-2 col-12 mb-1 text-md-right">
                                    <?php if($rec['status']=='Success' && !empty($rec['pdf_file'])): ?>
                                        <button class="btn btn-sm btn-success" onclick="downloadPDF(<?php echo $rec['id']; ?>)">
                                            <i class="fas fa-download"></i>
                                        </button>
                                    <?php elseif($rec['status']=='Rejected'): ?>
                                        <span class="text-danger" title="<?php echo $rec['rejection_reason'] ?? ''; ?>">
                                            <i class="fas fa-info-circle"></i> Refunded
                                        </span>
                                    <?php else: ?>
                                        <span class="text-warning"><i class="fas fa-clock"></i> Wait</span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="mt-1">
                                <small class="text-muted">
                                    <i class="fas fa-calendar"></i> <?php echo date('d M Y, h:i A', strtotime($rec['request_date'])); ?>
                                    | <i class="fas fa-hashtag"></i> <?php echo $rec['order_id']; ?>
                                    | <i class="fas fa-map-marker-alt"></i> <?php echo $rec['state']; ?>
                                </small>
                            </div>
                            
                            <?php if($rec['status']=='Pending' || $rec['status']=='Processing'): ?>
                            <div class="alert alert-info py-1 mt-2 mb-0" style="font-size:11px;">
                                <i class="fas fa-clock"></i> Processing...WAIT...
                            </div>
                            <?php endif; ?>
                            
                            <?php if($rec['status']=='Rejected'): ?>
                            <div class="alert alert-danger py-1 mt-2 mb-0" style="font-size:11px;">
                                <i class="fas fa-exclamation-circle"></i> <?php echo $rec['rejection_reason'] ?? 'Rejected - Amount Refunded'; ?>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endwhile; ?>
                <?php else: ?>
                    <div class="text-center py-5">
                        <i class="fas fa-inbox fa-4x text-muted mb-3"></i>
                        <h5 class="text-muted">No Requests Yet</h5>
                        <a href="voter_mobile_request.php" class="btn btn-success"><i class="fas fa-plus"></i> Create Request</a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
function downloadPDF(id) {
    window.open('download_voter_mobile_pdf.php?id=' + id, '_blank');
}

<?php if($pendingCount > 0 || $processingCount > 0): ?>
setTimeout(function() { location.reload(); }, 60000);
<?php endif; ?>
</script>

<?php include('../admin/footers.php'); ?>