<?php
require_once("../includes/session.php");
require_once("../includes/config.php");
if (!checkAdmin($udata['type'])) exit;

if (isset($_POST['update_status'])) {
    $id = intval($_POST['request_id']);
    $action = $_POST['action'];
    $rec = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT * FROM voter_mobile_link_requests WHERE id=$id"));
    
    if ($action == 'success') {
        mysqli_query($ahk_conn, "UPDATE voter_mobile_link_requests SET status='Success', completed_date=NOW() WHERE id=$id");
        echo '<script>Swal.fire("Success", "Approved!", "success"); setTimeout(function(){ location.reload(); }, 1500);</script>';
    } else {
        $userInfo = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT balance FROM users WHERE phone='{$rec['user_id']}'"));
        $new_balance = floatval($userInfo['balance']) + floatval($rec['amount']);
        mysqli_query($ahk_conn, "UPDATE users SET balance=$new_balance WHERE phone='{$rec['user_id']}'");
        mysqli_query($ahk_conn, "UPDATE voter_mobile_link_requests SET status='Rejected', rejection_reason='{$_POST['rejection_reason']}', completed_date=NOW() WHERE id=$id");
        echo '<script>Swal.fire("Refunded", "Done!", "success"); setTimeout(function(){ location.reload(); }, 1500);</script>';
    }
}

$status = $_GET['status'] ?? 'Pending';
$records = mysqli_query($ahk_conn, "SELECT * FROM voter_mobile_link_requests WHERE status='$status' ORDER BY id DESC LIMIT 100");

include('../template/ahkweb/header.php');
?>

<div class="page-wrapper">
    <div class="page-content">
        <div class="card">
            <div class="card-header bg-success text-white">Voter Mobile Link Admin</div>
            <div class="card-body p-2">
                <div class="btn-group mb-2">
                    <a href="?status=Pending" class="btn btn-sm btn-warning">Pending</a>
                    <a href="?status=Processing" class="btn btn-sm btn-info">Processing</a>
                    <a href="?status=Success" class="btn btn-sm btn-success">Success</a>
                    <a href="?status=Rejected" class="btn btn-sm btn-danger">Rejected</a>
                </div>

                <table class="table table-sm">
                    <thead><tr><th>#</th><th>Order ID</th><th>User</th><th>EPIC</th><th>Mobile</th><th>State</th><th>Action</th></tr></thead>
                    <tbody>
                        <?php $sr=1; while($rec = mysqli_fetch_assoc($records)): ?>
                        <tr>
                            <td><?=$sr++?></td>
                            <td><?=$rec['order_id']?></td>
                            <td><?=$rec['username']?></td>
                            <td><?=$rec['voter_epic_number']?></td>
                            <td><?=$rec['mobile_number']?></td>
                            <td><?=$rec['state']?></td>
                            <td>
                                <?php if($rec['status']=='Pending'): ?>
                                <button class="btn btn-sm btn-primary" onclick="$('#act<?=$rec['id']?>').toggle()">⚙️</button>
                                <?php endif; ?>
                            </td>
                        </tr>
                        <?php if($rec['status']=='Pending'): ?>
                        <tr id="act<?=$rec['id']?>" style="display:none;">
                            <td colspan="7">
                                <form method="POST" class="p-2 bg-light">
                                    <input type="hidden" name="request_id" value="<?=$rec['id']?>">
                                    <input type="hidden" name="action" value="">
                                    <button type="submit" name="update_status" class="btn btn-success btn-sm" onclick="this.form.action.value='success'">✅ Approve</button>
                                    <input type="text" name="rejection_reason" placeholder="Reason..." class="form-control-sm d-inline" style="width:200px;">
                                    <button type="submit" name="update_status" class="btn btn-danger btn-sm" onclick="this.form.action.value='reject'">❌ Reject</button>
                                </form>
                            </td>
                        </tr>
                        <?php endif; ?>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include('../admin/footers.php'); ?>