<?php
require_once("../includes/session.php");
require_once("../includes/config.php");

if (!checkAdmin($udata['type'])) {
    echo '<script>window.location="index.php";</script>';
    exit;
}

include('../template/ahkweb/header.php');
?>

<style>
.upcoming-container {
    max-width: 1200px;
    margin: 0 auto;
    padding: 40px 20px;
}
.upcoming-header {
    background: linear-gradient(135deg, #f093fb 0%, #f5576c 100%);
    color: white;
    padding: 40px;
    border-radius: 15px;
    text-align: center;
    margin-bottom: 40px;
}
.upcoming-card {
    background: white;
    border-radius: 12px;
    padding: 30px;
    margin-bottom: 20px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    transition: all 0.3s ease;
}
.upcoming-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 8px 25px rgba(0,0,0,0.15);
}
.service-icon-big {
    width: 80px;
    height: 80px;
    border-radius: 50%;
    background: linear-gradient(135deg, #667eea, #764ba2);
    display: flex;
    align-items: center;
    justify-content: center;
    margin: 0 auto 20px;
}
.badge-status {
    padding: 8px 15px;
    border-radius: 20px;
    font-size: 12px;
    font-weight: 600;
}
.badge-coming { background: #ffeaa7; color: #d63031; }
.badge-development { background: #74b9ff; color: #0984e3; }
.badge-testing { background: #a29bfe; color: #6c5ce7; }
</style>

<div class="page-wrapper">
    <div class="page-content">
        <div class="upcoming-container">
            <div class="upcoming-header">
                <h1 style="margin-bottom:10px;">🚀 Upcoming Services</h1>
                <p style="font-size:16px;margin:0;opacity:0.9;">Exciting new services launching soon!</p>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="upcoming-card">
                        <div class="service-icon-big">
                            <i class="fas fa-passport" style="font-size:40px;color:white;"></i>
                        </div>
                        <h3 style="text-align:center;margin-bottom:10px;">Passport Services</h3>
                        <p style="text-align:center;color:#666;margin-bottom:15px;">Apply for new passport, renewal, and status tracking</p>
                        <div style="text-align:center;">
                            <span class="badge-status badge-development">Under Development</span>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="upcoming-card">
                        <div class="service-icon-big">
                            <i class="fas fa-heartbeat" style="font-size:40px;color:white;"></i>
                        </div>
                        <h3 style="text-align:center;margin-bottom:10px;">Health Card Services</h3>
                        <p style="text-align:center;color:#666;margin-bottom:15px;">Ayushman Bharat, ESIC, and other health cards</p>
                        <div style="text-align:center;">
                            <span class="badge-status badge-testing">Testing Phase</span>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="upcoming-card">
                        <div class="service-icon-big">
                            <i class="fas fa-graduation-cap" style="font-size:40px;color:white;"></i>
                        </div>
                        <h3 style="text-align:center;margin-bottom:10px;">Education Certificates</h3>
                        <p style="text-align:center;color:#666;margin-bottom:15px;">Marksheet verification, degree certificates</p>
                        <div style="text-align:center;">
                            <span class="badge-status badge-coming">Coming Soon</span>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="upcoming-card">
                        <div class="service-icon-big">
                            <i class="fas fa-home" style="font-size:40px;color:white;"></i>
                        </div>
                        <h3 style="text-align:center;margin-bottom:10px;">Property Services</h3>
                        <p style="text-align:center;color:#666;margin-bottom:15px;">Property tax, registry verification, land records</p>
                        <div style="text-align:center;">
                            <span class="badge-status badge-coming">Coming Soon</span>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="upcoming-card">
                        <div class="service-icon-big">
                            <i class="fas fa-briefcase" style="font-size:40px;color:white;"></i>
                        </div>
                        <h3 style="text-align:center;margin-bottom:10px;">Business Registration</h3>
                        <p style="text-align:center;color:#666;margin-bottom:15px;">GST, MSME, Shop Act, Trade License</p>
                        <div style="text-align:center;">
                            <span class="badge-status badge-development">Under Development</span>
                        </div>
                    </div>
                </div>

                <div class="col-md-6">
                    <div class="upcoming-card">
                        <div class="service-icon-big">
                            <i class="fas fa-shield-alt" style="font-size:40px;color:white;"></i>
                        </div>
                        <h3 style="text-align:center;margin-bottom:10px;">Insurance Services</h3>
                        <p style="text-align:center;color:#666;margin-bottom:15px;">LIC, health insurance, vehicle insurance</p>
                        <div style="text-align:center;">
                            <span class="badge-status badge-coming">Coming Soon</span>
                        </div>
                    </div>
                </div>
            </div>

            <div style="text-align:center;margin-top:40px;">
                <a href="index" class="btn btn-primary btn-lg">
                    <i class="fas fa-arrow-left"></i> Back to Dashboard
                </a>
            </div>
        </div>
    </div>
</div>

<?php include('../admin/footers.php'); ?>