<?php
require_once("../includes/session.php");
require_once("../includes/config.php");
if (!checkAdmin($udata['type'])) exit;

if (isset($_POST['update_status'])) {
    $id = intval($_POST['request_id']);
    $action = $_POST['action'];
    $rec = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT * FROM tec_exam_requests WHERE id=$id"));
    
    if ($action == 'success' && isset($_FILES['pdf_file'])) {
        $file = $_FILES['pdf_file'];
        $fileData = file_get_contents($file['tmp_name']);
        $base64 = "data:application/pdf;base64," . base64_encode($fileData);
        
        mysqli_query($ahk_conn, "UPDATE tec_exam_requests SET status='Success', pdf_file='" . mysqli_real_escape_string($ahk_conn, $base64) . "', completed_date=NOW() WHERE id=$id");
        echo '<script>Swal.fire("Success", "Done", "success"); setTimeout(function(){ location.reload(); }, 1500);</script>';
    } else if ($action == 'reject') {
        $userInfo = mysqli_fetch_assoc(mysqli_query($ahk_conn, "SELECT balance FROM users WHERE phone='{$rec['user_id']}'"));
        $new_balance = floatval($userInfo['balance']) + floatval($rec['amount']);
        mysqli_query($ahk_conn, "UPDATE users SET balance=$new_balance WHERE phone='{$rec['user_id']}'");
        mysqli_query($ahk_conn, "UPDATE tec_exam_requests SET status='Rejected', rejection_reason='{$_POST['rejection_reason']}', completed_date=NOW() WHERE id=$id");
        echo '<script>Swal.fire("Refunded", "Done!", "success"); setTimeout(function(){ location.reload(); }, 1500);</script>';
    }
}

$records = mysqli_query($ahk_conn, "SELECT * FROM tec_exam_requests WHERE status='Pending' ORDER BY id DESC LIMIT 100");

include('../template/ahkweb/header.php');
?>

<div class="page-wrapper">
    <div class="page-content">
        <div class="card">
            <div class="card-header bg-info text-white">TEC Exam Admin</div>
            <div class="card-body p-2">
                <table class="table table-sm">
                    <thead><tr><th>#</th><th>Order</th><th>User</th><th>Exam Type</th><th>Roll No</th><th>Year</th><th>Action</th></tr></thead>
                    <tbody>
                        <?php $sr=1; while($rec = mysqli_fetch_assoc($records)): ?>
                        <tr>
                            <td><?=$sr++?></td>
                            <td><?=$rec['order_id']?></td>
                            <td><?=$rec['username']?></td>
                            <td><?=$rec['exam_type']?></td>
                            <td><?=$rec['roll_number']?></td>
                            <td><?=$rec['year']?></td>
                            <td>
                                <button class="btn btn-sm btn-primary" onclick="$('#act<?=$rec['id']?>').toggle()">⚙️</button>
                            </td>
                        </tr>
                        <tr id="act<?=$rec['id']?>" style="display:none;">
                            <td colspan="7">
                                <form method="POST" enctype="multipart/form-data" class="p-2">
                                    <input type="hidden" name="request_id" value="<?=$rec['id']?>">
                                    <input type="hidden" name="action" value="">
                                    <input type="file" name="pdf_file" accept=".pdf">
                                    <button type="submit" name="update_status" class="btn btn-success btn-sm" onclick="this.form.action.value='success'">✅</button>
                                    <input type="text" name="rejection_reason" placeholder="Reason">
                                    <button type="submit" name="update_status" class="btn btn-danger btn-sm" onclick="this.form.action.value='reject'">❌</button>
                                </form>
                            </td>
                        </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include('../admin/footers.php'); ?>