<?php
require_once("../includes/session.php");
require_once("../includes/config.php");

if (!isset($udata['pan_aadhaar_otp_service']) || $udata['pan_aadhaar_otp_service'] != 'YES') {
    echo '<script>window.location="index.php";</script>';
    exit;
}

$records = mysqli_query($ahk_conn, "SELECT * FROM pan_aadhaar_otp_requests WHERE username = '{$udata['name']}' ORDER BY id DESC");

include('../template/ahkweb/header.php');
?>

<style>
.status-badge {
    padding: 6px 12px;
    border-radius: 15px;
    font-size: 12px;
    font-weight: 600;
}
.status-pending { background: #fff3cd; color: #856404; }
.status-success { background: #d4edda; color: #155724; }
.status-rejected { background: #f8d7da; color: #721c24; }
</style>

<div class="page-wrapper">
    <div class="page-content">
        <div class="card">
            <div class="card-header bg-success text-white d-flex justify-content-between">
                <h5 class="mb-0"><i class="fas fa-credit-card"></i> My PAN Card Requests</h5>
                <a href="pan_aadhaar_request.php" class="btn btn-light btn-sm"><i class="fas fa-plus"></i> New Request</a>
            </div>
            <div class="card-body p-2">
                <?php if(mysqli_num_rows($records) > 0): ?>
                    <?php while($rec = mysqli_fetch_assoc($records)): 
                        $statusClass = strtolower($rec['status']);
                        $maskedAadhaar = 'XXXX-XXXX-' . substr($rec['aadhaar_number'], -4);
                    ?>
                    <div class="card mb-2" style="border-radius:10px;box-shadow:0 2px 10px rgba(0,0,0,0.08);">
                        <div class="card-body p-3">
                            <div class="row">
                                <div class="col-md-3">
                                    <small class="text-muted">Aadhaar</small>
                                    <div><strong><?php echo $maskedAadhaar; ?></strong></div>
                                </div>
                                <div class="col-md-3">
                                    <small class="text-muted">Name</small>
                                    <div><?php echo $rec['applicant_name']; ?></div>
                                </div>
                                <div class="col-md-2">
                                    <small class="text-muted">Amount</small>
                                    <div class="text-success"><strong>₹<?php echo $rec['amount']; ?></strong></div>
                                </div>
                                <div class="col-md-2">
                                    <small class="text-muted">Status</small>
                                    <div>
                                        <span class="status-badge status-<?php echo $statusClass; ?>">
                                            <?php echo $rec['status']; ?>
                                        </span>
                                    </div>
                                </div>
                                <div class="col-md-2 text-right">
                                    <?php if($rec['status'] == 'Success' && !empty($rec['pdf_file'])): ?>
                                        <button class="btn btn-sm btn-success" onclick="downloadPanPDF(<?php echo $rec['id']; ?>)">
                                            <i class="fas fa-download"></i>
                                        </button>
                                    <?php elseif($rec['status'] == 'Rejected'): ?>
                                        <span class="text-danger" title="<?php echo $rec['rejection_reason'] ?? ''; ?>">
                                            <i class="fas fa-info-circle"></i>
                                        </span>
                                    <?php else: ?>
                                        <span class="text-warning"><i class="fas fa-clock"></i></span>
                                    <?php endif; ?>
                                </div>
                            </div>
                            
                            <div class="mt-2">
                                <small class="text-muted">
                                    <i class="fas fa-calendar"></i> <?php echo date('d M Y, h:i A', strtotime($rec['request_date'])); ?>
                                    | <i class="fas fa-hashtag"></i> <?php echo $rec['order_id']; ?>
                                </small>
                            </div>
                            
                            <?php if($rec['status'] == 'Rejected'): ?>
                            <div class="alert alert-danger py-1 mt-2 mb-0" style="font-size:11px;">
                                <i class="fas fa-exclamation-circle"></i> <?php echo $rec['rejection_reason'] ?? 'Request rejected - Amount refunded'; ?>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                    <?php endwhile; ?>
                <?php else: ?>
                    <div class="text-center py-5">
                        <i class="fas fa-inbox fa-4x text-muted mb-3"></i>
                        <h5 class="text-muted">No Requests Yet</h5>
                        <a href="pan_aadhaar_request.php" class="btn btn-success"><i class="fas fa-plus"></i> Create Request</a>
                    </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>

<script>
function downloadPanPDF(id) {
    window.open('download_pan_pdf.php?id=' + id, '_blank');
}
</script>

<?php include('../admin/footers.php'); ?>