<?php
require_once("../includes/session.php");
require_once("../includes/config.php");

if (!checkAdmin($udata['type'])) {
    echo '<script>window.location="index.php";</script>';
    exit;
}

// Add News
if(isset($_POST['add_news'])) {
    $title = mysqli_real_escape_string($ahk_conn, $_POST['title']);
    $content = mysqli_real_escape_string($ahk_conn, $_POST['content']);
    
    mysqli_query($ahk_conn, "INSERT INTO admin_news (title, content) VALUES ('$title', '$content')");
    echo '<script>alert("News added successfully!"); window.location="news_admin.php";</script>';
}

// Delete News
if(isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    mysqli_query($ahk_conn, "DELETE FROM admin_news WHERE id=$id");
    echo '<script>alert("News deleted!"); window.location="news_admin.php";</script>';
}

include('../template/ahkweb/header.php');

$newsQuery = mysqli_query($ahk_conn, "SELECT * FROM admin_news ORDER BY created_at DESC");
?>

<style>
.news-form {
    background: white;
    padding: 30px;
    border-radius: 15px;
    box-shadow: 0 4px 15px rgba(0,0,0,0.1);
    margin-bottom: 30px;
}
.news-item {
    background: white;
    padding: 20px;
    border-radius: 12px;
    margin-bottom: 15px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}
</style>

<div class="page-wrapper">
    <div class="page-content">
        <h3 class="mb-4"><i class="fas fa-newspaper"></i> Manage News & Updates</h3>

        <div class="news-form">
            <h5 class="mb-3">Add New News</h5>
            <form method="POST">
                <div class="mb-3">
                    <label>Title</label>
                    <input type="text" name="title" class="form-control" required>
                </div>
                <div class="mb-3">
                    <label>Content</label>
                    <textarea name="content" class="form-control" rows="5" required></textarea>
                </div>
                <button type="submit" name="add_news" class="btn btn-primary">
                    <i class="fas fa-plus"></i> Add News
                </button>
            </form>
        </div>

        <h5 class="mb-3">All News</h5>
        <?php while($news = mysqli_fetch_assoc($newsQuery)): ?>
            <div class="news-item">
                <div class="d-flex justify-content-between align-items-start">
                    <div style="flex:1;">
                        <h6><?php echo htmlspecialchars($news['title']); ?></h6>
                        <small class="text-muted"><?php echo date('d M Y, h:i A', strtotime($news['created_at'])); ?></small>
                        <p class="mt-2 mb-0"><?php echo nl2br(htmlspecialchars($news['content'])); ?></p>
                    </div>
                    <a href="?delete=<?php echo $news['id']; ?>" class="btn btn-danger btn-sm" onclick="return confirm('Delete this news?')">
                        <i class="fas fa-trash"></i>
                    </a>
                </div>
            </div>
        <?php endwhile; ?>
    </div>
</div>

<?php include('../admin/footers.php'); ?>