<?php
require_once("../includes/session.php");
require_once("../includes/config.php");

if (!checkAdmin($udata['type'])) {
    echo '<script>window.location="index.php";</script>';
    exit;
}

// Mark as read
if(isset($_POST['reply_message'])) {
    $msg_id = intval($_POST['msg_id']);
    $reply = mysqli_real_escape_string($ahk_conn, $_POST['reply']);
    
    mysqli_query($ahk_conn, "UPDATE contact SET reply='$reply', is_read=1 WHERE id=$msg_id");
    echo '<script>alert("Reply sent!"); window.location="messages_admin.php";</script>';
}

// Mark as read without reply
if(isset($_GET['mark_read'])) {
    $msg_id = intval($_GET['mark_read']);
    mysqli_query($ahk_conn, "UPDATE contact SET is_read=1 WHERE id=$msg_id");
    echo '<script>window.location="messages_admin.php";</script>';
}

include('../template/ahkweb/header.php');

$messagesQuery = mysqli_query($ahk_conn, "SELECT * FROM contact ORDER BY created_at DESC");
?>

<style>
.message-card {
    background: white;
    border-radius: 12px;
    padding: 20px;
    margin-bottom: 15px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.1);
}
.message-card.unread {
    border-left: 5px solid #f39c12;
    background: #fff9e6;
}
.message-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 15px;
}
.badge-unread {
    background: #f39c12;
    color: white;
    padding: 5px 10px;
    border-radius: 15px;
    font-size: 11px;
}
</style>

<div class="page-wrapper">
    <div class="page-content">
        <h3 class="mb-4"><i class="fas fa-envelope"></i> All Messages</h3>

        <?php while($msg = mysqli_fetch_assoc($messagesQuery)): ?>
            <div class="message-card <?php echo $msg['is_read'] == 0 ? 'unread' : ''; ?>">
                <div class="message-header">
                    <div>
                        <h6 class="mb-1"><?php echo htmlspecialchars($msg['name']); ?></h6>
                        <small class="text-muted"><?php echo $msg['email']; ?> | <?php echo $msg['phone']; ?></small>
                    </div>
                    <div>
                        <?php if($msg['is_read'] == 0): ?>
                            <span class="badge-unread">NEW</span>
                        <?php endif; ?>
                        <small class="text-muted d-block"><?php echo date('d M Y, h:i A', strtotime($msg['created_at'])); ?></small>
                    </div>
                </div>
                
                <div class="mb-3">
                    <strong>Message:</strong>
                    <p class="mb-0 mt-2"><?php echo nl2br(htmlspecialchars($msg['mess'])); ?></p>
                </div>

                <?php if(!empty($msg['reply'])): ?>
                    <div class="alert alert-success">
                        <strong>Your Reply:</strong>
                        <p class="mb-0 mt-2"><?php echo nl2br(htmlspecialchars($msg['reply'])); ?></p>
                    </div>
                <?php else: ?>
                    <form method="POST" class="mt-3">
                        <input type="hidden" name="msg_id" value="<?php echo $msg['id']; ?>">
                        <div class="mb-2">
                            <textarea name="reply" class="form-control" rows="3" placeholder="Type your reply..." required></textarea>
                        </div>
                        <button type="submit" name="reply_message" class="btn btn-primary btn-sm">
                            <i class="fas fa-reply"></i> Send Reply
                        </button>
                        <a href="?mark_read=<?php echo $msg['id']; ?>" class="btn btn-secondary btn-sm">
                            <i class="fas fa-check"></i> Mark as Read
                        </a>
                    </form>
                <?php endif; ?>
            </div>
        <?php endwhile; ?>
    </div>
</div>

<?php include('../admin/footers.php'); ?>