<?php
include('../includes/session.php');
include('../includes/config.php');
include('../template/ahkweb/header.php');

// Admin Access Check
if (!checkAdmin($udata['type'])) {
    echo "<script>window.location='index';</script>";
    die();
}

// Delete Complaint
if (isset($_GET['deleteid']) && !empty($_GET['deleteid'])) {
    $deleteid = base64_decode(mysqli_real_escape_string($ahk_conn, $_GET['deleteid']));
    if (mysqli_query($ahk_conn, "DELETE FROM complaints WHERE complaint_id='$deleteid'")) {
        showAlert('Complaint Deleted Successfully');
        ahkRedirect('complaint_request_list_admin', 1200);
    }
}

// Update Complaint Status & Remark
if (isset($_POST['status']) && isset($_POST['remark']) && isset($_POST['id'])) {
    $status = mysqli_real_escape_string($ahk_conn, $_POST['status']);
    $remark = mysqli_real_escape_string($ahk_conn, $_POST['remark']);
    $id = mysqli_real_escape_string($ahk_conn, $_POST['id']);

    $update = mysqli_query($ahk_conn, "UPDATE complaints SET status='$status', remark='$remark' WHERE complaint_id='$id'");
    if ($update) {
        showAlert('Complaint Updated Successfully');
        ahkRedirect('complaint_request_list_admin', 1200);
    } else {
        showAlert('Update Failed');
    }
}
?>

<!-- Admin Complaint Panel -->
<div class="page-wrapper">
    <div class="page-content">
        <div class="card radius-10">
            <div class="card-body">
                <h5 class="mb-3">Complaint Management (Admin)</h5>
                <hr>
                <div class="table-responsive">
                    <table id="example2" class="table table-bordered align-middle mb-0">
                        <thead class="table-light">
                            <tr>
                                <th class="text-center">#</th>
                                <th class="text-center">User</th>
                                <th class="text-center">Complaint Type</th>
                                <th class="text-center">Message</th>
                                <th class="text-center">UTR</th>
                                <th class="text-center">Date</th>
                                <th class="text-center">Status</th>
                                <th class="text-center">Remark</th>
                                <th class="text-center">Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $query = mysqli_query($ahk_conn, "SELECT * FROM complaints ORDER BY complaint_id DESC");
                            if (mysqli_num_rows($query) > 0) {
                                $x = 0;
                                while ($row = mysqli_fetch_assoc($query)) {
                                    $x++;
                                    ?>
                                    <tr>
                                        <td class="text-center"><?= $x; ?></td>
                                        <td class="text-center">
                                            <?= htmlspecialchars($row['username']); ?><br>
                                            <small>User ID: <?= $row['user_id']; ?></small>
                                        </td>
                                        <td class="text-center"><?= htmlspecialchars($row['complaint_type']); ?></td>
                                        <td class="text-center">
    <div class="message-box resizable-box text-center">
        <?= nl2br(htmlspecialchars($row['message'])); ?>
    </div>
</td>
                                        <td class="text-center"><?= $row['utrnumber'] ?? '-'; ?></td>
                                        <td class="text-center"><?= date('d M Y h:i A', strtotime($row['date_time'])); ?></td>
                                        <td class="text-center">
                                            <?php if ($row['status'] === 'Open') { ?>
                                                <span class="badge bg-warning">Open</span>
                                            <?php } elseif ($row['status'] === 'Close') { ?>
                                                <span class="badge bg-success">Closed</span>
                                            <?php } else { ?>
                                                <span class="badge bg-secondary">-</span>
                                            <?php } ?>
                                        </td>
                                        <td class="text-center"><?= htmlspecialchars($row['remark'] ?? ''); ?></td>
                                        <td class="text-center">
                                            <form method="POST" style="min-width:200px;">
                                                <input type="hidden" name="id" value="<?= $row['complaint_id']; ?>">
                                                <select name="status" class="form-control mb-2" required>
                                                    <option value="">-- Status --</option>
                                                    <option value="Open" <?= $row['status'] == 'Open' ? 'selected' : '' ?>>Open</option>
                                                    <option value="Close" <?= $row['status'] == 'Close' ? 'selected' : '' ?>>Close</option>
                                                </select>
                                                <input type="text" name="remark" class="form-control mb-2" placeholder="Remark" value="<?= htmlspecialchars($row['remark']); ?>" required>
                                                <button type="submit" class="btn btn-success btn-sm">Update</button>
                                                <a href="?deleteid=<?= base64_encode($row['complaint_id']); ?>" onclick="return confirm('Are you sure to delete this complaint?');" class="btn btn-danger btn-sm">Delete</a>
                                            </form>
                                        </td>
                                    </tr>
                                    <?php
                                }
                            } else {
                                echo '<tr><td colspan="9" class="text-center">No complaints found.</td></tr>';
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.message-box {
    max-height: 120px;
    overflow-y: auto;
    overflow-x: hidden;
    white-space: pre-wrap;
    word-wrap: break-word;
    text-align: center; /* <-- Center the text inside the box */
    padding: 10px;
    font-size: 14px;
    line-height: 1.5;
    background-color: #fefefe;
    border: 1px solid #dee2e6;
    border-radius: 10px;
    box-shadow: inset 0 1px 2px rgba(0, 0, 0, 0.06);
    scrollbar-width: thin;
    scrollbar-color: #bbb #eee;
}

/* Make box resizable */
.resizable-box {
    resize: vertical;
    min-height: 60px;
}

/* WebKit scrollbar styling */
.message-box::-webkit-scrollbar {
    width: 6px;
}
.message-box::-webkit-scrollbar-track {
    background: #f1f1f1;
    border-radius: 8px;
}
.message-box::-webkit-scrollbar-thumb {
    background-color: #adb5bd;
    border-radius: 8px;
}
</style>
<?php include('footer.php'); ?>

<!-- JS Includes -->
<script src="../template/ahkweb/assets/js/bootstrap.bundle.min.js"></script>
<script src="../template/ahkweb/assets/js/jquery.min.js"></script>
<script src="../template/ahkweb/assets/plugins/simplebar/js/simplebar.min.js"></script>
<script src="../template/ahkweb/assets/plugins/metismenu/js/metisMenu.min.js"></script>
<script src="../template/ahkweb/assets/plugins/perfect-scrollbar/js/perfect-scrollbar.js"></script>
<script src="../template/ahkweb/assets/plugins/chartjs/chart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-2.0.2.min.js"></script>
<script src="../template/ahkweb/assets/plugins/vectormap/jquery-jvectormap-world-mill-en.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery.easy-pie-chart/jquery.easypiechart.min.js"></script>
<script src="../template/ahkweb/assets/plugins/sparkline-charts/jquery.sparkline.min.js"></script>
<script src="../template/ahkweb/assets/plugins/jquery-knob/jquery.knob.js"></script>
<script>
    $(function () {
        $(".knob").knob();
    });
</script>
<script src="../template/ahkweb/assets/js/index.js"></script>
<script src="../template/ahkweb/assets/js/app.js"></script>
<script src="../template/ahkweb/assets/plugins/datatable/js/jquery.dataTables.min.js"></script>
<script src="../template/ahkweb/assets/plugins/datatable/js/dataTables.bootstrap5.min.js"></script>
<script>
    $(document).ready(function () {
        var table = $('#example2').DataTable({
            lengthChange: false,
            buttons: ['copy', 'excel', 'pdf', 'print']
        });
        table.buttons().container()
            .appendTo('#example2_wrapper .col-md-6:eq(0)');
    });
</script>
<!-- Created By FlexSecure {flex4upoint} -->